/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.en.AbstractEnglishSpellerRule;
import org.languagetool.rules.en.VariantInfo;

public final class MorfologikBritishSpellerRule
extends AbstractEnglishSpellerRule {
    public static final String RULE_ID = "MORFOLOGIK_RULE_EN_GB";
    private static final String RESOURCE_FILENAME = "/en/hunspell/en_GB.dict";
    private static final String LANGUAGE_SPECIFIC_PLAIN_TEXT_DICT = "en/hunspell/spelling_en-GB.txt";
    private static final Map<String, String> US_ENGLISH = MorfologikBritishSpellerRule.loadWordlist("en/en-US-GB.txt", 0);

    public MorfologikBritishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
    }

    @Override
    protected VariantInfo isValidInOtherVariant(String word) {
        String otherVariant = US_ENGLISH.get(word);
        if (otherVariant != null) {
            return new VariantInfo("American English", otherVariant);
        }
        return null;
    }

    @Override
    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public String getLanguageVariantSpellingFileName() {
        return LANGUAGE_SPECIFIC_PLAIN_TEXT_DICT;
    }
}

